﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;

namespace AZVIC.Ei8htPOS.DAL
{
    public class ProductSubCategoryDB
    {
        public static ProductSubCategory GetItem(Guid productSubCategoryID, Guid productCategoryID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
                parameters.Add(new SqlParameter("@ProductSubCategoryID", ((productSubCategoryID != Guid.Empty && productSubCategoryID != null) ? productSubCategoryID : (object)DBNull.Value)));
                parameters.Add(new SqlParameter("@ProductCategoryID", ((productCategoryID != Guid.Empty && productCategoryID != null) ? productCategoryID : (object)DBNull.Value)));
                parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

                return SQLHelper.RetrieveObject<ProductSubCategory>("spGetProductSubCategory", parameters);
            
        }

        public static List<ProductSubCategory> GetList(Guid productSubCategoryID, Guid productCategoryID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
                parameters.Add(new SqlParameter("@ProductSubCategoryID", ((productSubCategoryID != Guid.Empty && productSubCategoryID != null) ? productSubCategoryID : (object)DBNull.Value)));
                parameters.Add(new SqlParameter("@ProductCategoryID", ((productCategoryID != Guid.Empty && productCategoryID != null) ? productCategoryID : (object)DBNull.Value)));
                parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

                return SQLHelper.RetrieveList<ProductSubCategory>("spGetProductSubCategory", parameters);
            
        }

        public static DataTable GetDataTable(Guid productSubCategoryID, Guid productCategoryID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
                parameters.Add(new SqlParameter("@ProductSubCategoryID", ((productSubCategoryID != Guid.Empty && productSubCategoryID != null) ? productSubCategoryID : (object)DBNull.Value)));
                parameters.Add(new SqlParameter("@ProductCategoryID", ((productCategoryID != Guid.Empty && productCategoryID != null) ? productCategoryID : (object)DBNull.Value)));
                parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

                return SQLHelper.ExecuteDataTable("spGetProductSubCategory", parameters);
            
        }

        public static DataSet GetDataSet(Guid productSubCategoryID, Guid productCategoryID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
                parameters.Add(new SqlParameter("@ProductSubCategoryID", ((productSubCategoryID != Guid.Empty && productSubCategoryID != null) ? productSubCategoryID : (object)DBNull.Value)));
                parameters.Add(new SqlParameter("@ProductCategoryID", ((productCategoryID != Guid.Empty && productCategoryID != null) ? productCategoryID : (object)DBNull.Value)));
                parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

                return SQLHelper.ExecuteDataSet("spGetProductSubCategory", parameters);
            
        }

        public static void Save(ProductSubCategory myProductSubCategory)
        {
            myProductSubCategory.Mode = ((myProductSubCategory.UniqueID != Guid.Empty && myProductSubCategory.UniqueID != null) ? GlobalConfigurations.Mode.Update : GlobalConfigurations.Mode.Insert);
            myProductSubCategory.UniqueID = ((myProductSubCategory.UniqueID != Guid.Empty && myProductSubCategory.UniqueID != null) ? myProductSubCategory.UniqueID : Guid.NewGuid());
            if (myProductSubCategory.Mode == GlobalConfigurations.Mode.Insert)
            {
                myProductSubCategory.IsActive = true;
            }

            List<SqlParameter> parameters = new List<SqlParameter>();
                parameters.Add(new SqlParameter("@ProductSubCategoryID", myProductSubCategory.UniqueID));
                parameters.Add(new SqlParameter("@ProductCategoryID", ((myProductSubCategory.ProductCategoryID != Guid.Empty && myProductSubCategory.ProductCategoryID != null) ? myProductSubCategory.ProductCategoryID : (object)DBNull.Value)));
                parameters.Add(new SqlParameter("@SubCategoryName", (string.IsNullOrEmpty(myProductSubCategory.SubCategoryName) ? (object)DBNull.Value : myProductSubCategory.SubCategoryName)));
                parameters.Add(new SqlParameter("@SequenceNo", (myProductSubCategory.SequenceNo != 0) ? (object)DBNull.Value : myProductSubCategory.SequenceNo));
                parameters.Add(new SqlParameter("@CreatedBy", ((myProductSubCategory.UserAccountID != Guid.Empty && myProductSubCategory.UserAccountID != null) ? myProductSubCategory.UserAccountID : (object)DBNull.Value)));
                parameters.Add(new SqlParameter("@IsActive", myProductSubCategory.IsActive));
                //parameters.Add(new SqlParameter("@IsDeleted", myProductCategory.IsDeleted));
                parameters.Add(new SqlParameter("@Mode", myProductSubCategory.Mode));

                SQLHelper.ExecuteQuery("spAddOrUpdateProductSubCategory", parameters);
            
        }
    }
}
